/***************************************************************************

   Source file Thermal_system_full_dsrtvdf.c:

   Definition of function that initializes the global TRC pointers

   4.5 (02-May-2021)
   Fri Feb 21 15:05:36 2025

   Copyright 2025, dSPACE GmbH. All rights reserved.

 *****************************************************************************/

/* Include header file. */
#include "Thermal_system_full_dsrtvdf.h"
#include "Thermal_system_full.h"
#include "Thermal_system_full_private.h"

/* Compiler options to turn off optimization. */
#if !defined(DS_OPTIMIZE_INIT_TRC_POINTERS)
#ifdef _MCCPPC

#pragma options -nOt -nOr -nOi -nOx

#endif

#ifdef __GNUC__

#pragma GCC optimize ("O0")

#endif

#ifdef _MSC_VER

#pragma optimize ("", off)

#endif
#endif

/* Definition of Global pointers to data type transitions (for TRC-file access) */
volatile real_T *p_0_Thermal_system_full_real_T_0 = NULL;
volatile real_T *p_1_Thermal_system_full_real_T_0 = NULL;
volatile real_T *p_2_Thermal_system_full_real_T_0 = NULL;
volatile int_T *p_2_Thermal_system_full_int_T_2 = NULL;
volatile int32_T *p_2_Thermal_system_full_int32_T_3 = NULL;
volatile boolean_T *p_2_Thermal_system_full_boolean_T_4 = NULL;
volatile real_T *p_3_Thermal_system_full_real_T_0 = NULL;

/*
 *  Declare the functions, that initially assign TRC pointers
 */
static void rti_init_trc_pointers_0(void);

/* Global pointers to data type transitions are separated in different functions to avoid overloading */
static void rti_init_trc_pointers_0(void)
{
  p_0_Thermal_system_full_real_T_0 = &Thermal_system_full_B.TransferFcn;
  p_1_Thermal_system_full_real_T_0 = &Thermal_system_full_P.T_init;
  p_2_Thermal_system_full_real_T_0 =
    &Thermal_system_full_DW.INPUT_1_1_1_Discrete[0];
  p_2_Thermal_system_full_int_T_2 = &Thermal_system_full_DW.STATE_1_Modes[0];
  p_2_Thermal_system_full_int32_T_3 =
    &Thermal_system_full_DW.STATE_1_MASS_MATRIX_PR;
  p_2_Thermal_system_full_boolean_T_4 =
    &Thermal_system_full_DW.RTP_1_SetParametersNeeded;
  p_3_Thermal_system_full_real_T_0 = &Thermal_system_full_X.TransferFcn_CSTATE;
}

void Thermal_system_full_rti_init_trc_pointers(void)
{
  rti_init_trc_pointers_0();
}
